#version 130
#extension GL_EXT_gpu_shader4 : enable
//Plane DeformationsMod01.fsh  by   platosha  

//https://www.shadertoy.com/view/4ltGRs
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Plane Deformations
// by Anton Platonov <platosha@gmail.com>
// twitter.com/platosha

// Inspired by iq’s articles and code. See:
// https://iquilezles.org/articles/deform
// https://iquilezles.org/apps/shadertoy/index2.html

const float TAU = 6.2832;

//void mainImage( out vec4 fragColor, in vec2 fragCoord ) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord ) {   
    float time = iTime;

	vec2 position = ( fragCoord.xy / iResolution.xy );
	vec2 p = -1.0 + 2.0 * position;
	p *= vec2( iResolution.x/iResolution.y, 1.0 );
	
	float alpha = -time * 0.13;
	float sinA = sin(alpha), cosA = cos(alpha);
	p = vec2(cosA*p.x+sinA*p.y, -sinA*p.x+cosA*p.y);
	
	vec2 q = p;
	vec2 dir = vec2( sin(time*0.19), cos(time*0.27) ) * 0.333;
	q = p + dir/pow(0.5, 1.0-dot(p-dir,p-dir));
	
	q = mix(q, p, sin(time*0.78));
	
	float zr = 1.0/length(q);
	float zp = 1.0/abs(q.y);
	float mc = sin(time*0.16)*.5 + .5;
	mc = smoothstep(0.0, 1.0, mc);
	mc = smoothstep(0.0, 1.0, mc);
	mc = smoothstep(0.0, 1.0, mc);
	mc = smoothstep(0.0, 1.0, mc);
	float z = mix(zr, zp, mc);
	float ur = 5.0*atan(q.x*sign(q.y), abs(q.y))/TAU + cos(0.2*z*TAU+time*1.37) * 1.2 * sin( time * 0.21 );
	float up = q.x*sign(q.y)*z;
	float u = mix(ur, up, mc);
	vec2 uv = vec2(u, (1.0+mc*2.0)*z);
	
	float mv = sin(time * 0.55);
	
	float color = 0.0;
	color = cos(uv.x*TAU) * cos(uv.y*TAU + time*7.7);
	color = pow(abs(cos(color*TAU)), 3.0);
	
	float color2 = 0.0;
	color2 = cos(uv.x*TAU*2.0);
	color2 -= 0.25;
		
	float shadow = 1.0/(z*z);
	vec3 rc = vec3(0.9, 1.0, 0.8)*color +
		  vec3(0.3, 0.7, 0.6)*color2;
	rc *= shadow;
	
	fragColor = vec4( rc, 1.0 );
return fragColor; 
}
///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.